#include "global.h"
#include "md5.h"
#include "hmac_md5.h"
#include <errno.h>
#include <pwd.h>
#include <stdio.h>
#include <unistd.h>

#define LINE_MAX 256
#define SMTP_PASSWD_FILE "/etc/poppasswd"
char up[513];
int uplen;
static char hextab[]="0123456789abcdef";

int doit(unsigned char *testlogin, unsigned char *challenge, unsigned char *response)
{
   static char line[LINE_MAX + 1];
   int found_user= 0;
   unsigned char *password = NULL;
   unsigned char digest[16];
   unsigned char digascii[33];
   unsigned char h;
   FILE *fp;
   int j;

   char *linepnt;

   if ((fp = fopen(SMTP_PASSWD_FILE, "rt")) == NULL) _exit(2);
   while (fgets(line, LINE_MAX, fp) != NULL) {
         if ((linepnt = strchr(line, '\n')) != NULL) {
	 *linepnt = 0;
      }
      if ((linepnt = strtok(line, ":")) == NULL) _exit(2);
      if (strcmp(linepnt, testlogin) == 0) {
	 if ((linepnt = strtok(NULL, ":")) == NULL) _exit(2);
	 password = linepnt;
	 found_user = 1;
	 break;
      }
   }   
   fclose(fp);

   if (!found_user) return(1);

   hmac_md5( challenge, strlen(challenge), password, strlen(password), digest);

   digascii[32]=0;
   
   for (j=0;j<16;j++)
   {
     h=digest[j] >> 4;
     digascii[2*j]=hextab[h];
     h=digest[j] & 0x0f;
     digascii[(2*j)+1]=hextab[h];
   }   
   return(strcmp(digascii,response) && strcmp(password,challenge));
}

void main(int argc,char **argv)
{
  char *login;
  char *response;
  char *challenge;
  int r;
  int i;
  int accepted;
 
  if (!argv[1]) _exit(2);
 
  uplen = 0;
  for (;;) {
    do
      r = read(3,up + uplen,sizeof(up) - uplen);
    while ((r == -1) && (errno == EINTR));
    if (r == -1) _exit(111);
    if (r == 0) break;
    uplen += r;
    if (uplen >= sizeof(up)) _exit(1);
  }

  close(3);

  i = 0;
  login = up + i;
  while (up[i++]) if (i == uplen) _exit(2);
  challenge = up + i;
  if (i == uplen) _exit(2);
  while (up[i++]) if (i == uplen) _exit(2);
  response = up + i;

  accepted=doit(login,challenge,response);
  
  for (i = 0;i < sizeof(up);++i) up[i] = 0;
 
  if (accepted)  _exit(1);
    execvp(argv[1],argv + 1);
    _exit(111);
}
