#!/bin/bash

data1=`date -d '1 day ago' +'%Y%m%d'`
data2=`date -d '2 months ago' +'%Y%m'`
datadir='/data/backup/daily/'
exportdir='/home/kakaku/export'

rm ${exportdir}/*

cp /usr/local/lib/php.ini      ${exportdir}/conf_usr-local-lib-php.ini
cp /data/pgsql/postgresql.conf ${exportdir}/conf_data-pgsql-postgresql.conf
cp /usr/local/etc/proftpd.conf ${exportdir}/conf_usr-local-etc-proftpd.conf
cp /etc/init.d/rc.local        ${exportdir}/conf_etc-init.d-rc.local
cp /etc/hostname               ${exportdir}/conf_etc-hostname
cp /etc/hosts                  ${exportdir}/conf_etc-hosts
cp /etc/network/interfaces     ${exportdir}/conf_etc-network-interfaces
cp /etc/resolv.conf            ${exportdir}/conf_etc-resolv.conf
cp /usr/local/bin/*.sh         ${exportdir}/

tar -czf ${exportdir}/miscfiles.tar.gz ${exportdir}/*
rm ${exportdir}/conf_*
rm ${exportdir}/*sh

su - postgres -c "/usr/local/pgsql/bin/pg_dump -f ${exportdir}/tetz tetz"
gzip ${exportdir}/tetz

rm /home/kakaku/htdocs/nenji_1dc3d08b2/*
rm /home/kakaku/htdocs/npy_1dc3d08b2/*
rm /home/kakaku/htdocs/tdfk_1dc3d08b2/*

tar -czf ${exportdir}/htdocs.tar.gz /home/kakaku/htdocs 
tar -czf ${exportdir}/apacheconf.tar.gz /usr/local/apache2/conf

mkdir ${datadir}${data1}
cp ${exportdir}/* ${datadir}${data1}/

scp ${exportdir}/* demekin@clement.calico.jp:/home/demekin/dat-misc/

rm -rf ${datadir}${data2}*
rm ${exportdir}/*


exit 0

